using System;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Zwizy opis dla CompanyEventControl
/// </summary>
public class CompanyEventControl : Control, ICallbackEventHandler
{
   private DataTable locations;
   public CompanyEventControl()
   {
      //
      // Do wykonania: Tutaj wstaw definicj konstruktora(w)
      //
   }

   #region ICallbackEventHandler Members

   public string GetCallbackResult()
   {
      StringBuilder sb = new StringBuilder();
      foreach (DataRow row in locations.Rows)
      {
         sb.AppendFormat("{0}|{1}||", row["LocationID"], row["Description"]);
      }
      return sb.ToString();
   }

   public void RaiseCallbackEvent(string eventArgument)
   {
      using (SqlConnection conn =
        new SqlConnection("data source=localhost; initial catalog=SampleDB; Integrated Security=SSPI;"))
      {
         conn.Open();
         SqlCommand cmd = conn.CreateCommand();
         cmd.CommandText = "SELECT LocationID, Description FROM Locations WHERE CompanyID = " +
           eventArgument;
         SqlDataAdapter da = new SqlDataAdapter(cmd);
         locations = new DataTable();
         da.Fill(locations);
      }
   }

   #endregion
}

public class LocationEventControl : Control, ICallbackEventHandler
{
   private DataTable offices;
   public LocationEventControl()
   {
      //
      // Do wykonania: Tutaj wstaw definicj konstruktora(w)
      //
   }

   #region ICallbackEventHandler Members

   public string GetCallbackResult()
   {
      StringBuilder sb = new StringBuilder();
      foreach (DataRow row in offices.Rows)
      {
         sb.AppendFormat("{0}|{1}||", row["OfficeID"], row["Description"]);
      }
      return sb.ToString();
   }

   public void RaiseCallbackEvent(string eventArgument)
   {
      using (SqlConnection conn =
        new SqlConnection("data source=localhost; initial catalog=SampleDB; Integrated Security=SSPI;"))
      {
         offices = new DataTable("Offices");
         conn.Open();
         SqlCommand cmd = conn.CreateCommand();
         cmd.CommandText = "SELECT OfficeID, Description FROM Offices WHERE LocationID = " +
           eventArgument;
         SqlDataAdapter da = new SqlDataAdapter(cmd);
         da.Fill(offices);
      }
   }

   #endregion
}
